/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.simulation;

import DE.siemens.ad.logo.app.ActionOwner;
import DE.siemens.ad.logo.app.action.ActionFactory;
import DE.siemens.ad.logo.app.action.ActionManager;
import DE.siemens.ad.logo.app.action.LogoToggleAction;
import DE.siemens.ad.logo.app.comp.HideableToolBar;
import DE.siemens.ad.logo.app.comp.IncrementableIntegerJTextField;
import DE.siemens.ad.logo.app.comp.RolloverButton;
import DE.siemens.ad.logo.app.comp.RolloverButtonToolBar;
import DE.siemens.ad.logo.dialog.comp.TimeUnitListCellRenderer;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.model.InterpreterListener;
import DE.siemens.ad.logo.model.Minutes;
import DE.siemens.ad.logo.model.Seconds;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.StateMachine;
import DE.siemens.ad.pdraw.simulation.OfflineInterpreter;
import DE.siemens.ad.pdraw.simulation.SimulationManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.MaskFormatter;
import javax.swing.text.NumberFormatter;

public class SimulationControl
implements ActionOwner {
    private Timer labelUpdater = null;
    private SimulationManager fSimulationManager;
    private ActionFactory fActionFactory;
    private ActionManager fActionManager;
    private RolloverButtonToolBar fToolbar;
    private JComponent fStepAmountContainer;
    private JComponent fStepPanel;
    private JLabel fStepProgress;
    private IncrementableIntegerJTextField fCycleField;
    private JFormattedTextField fTimeField;
    private JComboBox fCbXStepUnit;
    private JComboBox fCbxSimulationSpeed;
    private TimeLabel fLblTime;
    private RolloverButton fNetButton;

    public Timer getLabelUpdater() {
        if (this.labelUpdater == null) {
            this.labelUpdater = new Timer(50, new ActionListener(){
                private long lastTime = -1L;

                public void actionPerformed(ActionEvent e) {
                    long interpreterTime = SimulationControl.this.getInterpreter().getCurrentSimulationClockTime();
                    if (Math.abs(interpreterTime - this.lastTime) > 500L) {
                        SimulationControl.this.fLblTime.setTime(interpreterTime);
                        SimulationControl.this.fLblTime.repaint();
                        this.lastTime = interpreterTime;
                    }
                }
            });
            this.labelUpdater.setRepeats(true);
        }
        return this.labelUpdater;
    }

    public SimulationControl(SimulationManager simulationManager) {
        this.fSimulationManager = simulationManager;
        this.getInterpreter().addInterpreterListener(new InterpreterHandler());
        this.getInterpreter().getStateMachine().addStateChangedListener(new InterpreterStateChangedHandler());
        this.initComponents();
        this.registerListeners();
        this.setLabels();
        this.loadFieldContents();
    }

    public ActionFactory getActionFactory() {
        if (this.fActionFactory == null) {
            this.fActionFactory = new ActionFactory(this);
        }
        return this.fActionFactory;
    }

    public ActionManager getActionManager() {
        if (this.fActionManager == null) {
            this.fActionManager = new ActionManager(this);
        }
        return this.fActionManager;
    }

    public Window getWindow() {
        return this.fSimulationManager.getEditor().getWindow();
    }

    public JToolBar getToolbar() {
        return this.fToolbar;
    }

    private RolloverButtonToolBar createToolBar() {
        if (this.fToolbar == null) {
            this.fToolbar = new HideableToolBar();
            ((HideableToolBar)this.fToolbar).setTitle(Language.getString("simulationControl.title", "Simulation control"));
            this.fNetButton = new RolloverButton();
            this.fNetButton.setIcon(Global.getIcon("Connected.gif"));
            this.fNetButton.setPressedIcon(Global.getIcon("Disconnected.gif"));
            this.fToolbar.add(this.fNetButton);
            ActionFactory actionFactory = this.getActionFactory();
            this.fToolbar.add(actionFactory.getAction("DE.siemens.ad.pdraw.simulation.StartSimulationAction"));
            this.fToolbar.add(actionFactory.getAction("DE.siemens.ad.pdraw.simulation.StopSimulationAction"));
            this.fToolbar.add(actionFactory.getAction("DE.siemens.ad.pdraw.simulation.SuspendResumeAction"));
            this.fToolbar.addSeparator();
            this.fToolbar.add(actionFactory.getAction("DE.siemens.ad.pdraw.simulation.StepSimulationAction"));
            this.fStepProgress = new JLabel("...");
            this.fStepPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = null;
            this.fStepAmountContainer = new JPanel(new BorderLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 1;
            this.fStepPanel.add((Component)this.fStepAmountContainer, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.fill = 1;
            this.fStepPanel.add((Component)this.fCbXStepUnit, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 13;
            this.fStepPanel.add((Component)this.fStepProgress, gbc);
            this.fStepAmountContainer.add(this.fCycleField);
            this.fStepProgress.setText("0");
            this.fToolbar.add(this.fStepPanel);
            this.fToolbar.addSeparator();
            this.fToolbar.add(this.fLblTime);
            this.fToolbar.add((LogoToggleAction)actionFactory.getAction("DE.siemens.ad.pdraw.simulation.SetSimulationClockAction"));
            if (LogoProperties.instance().getBooleanProperty("simulation.speedControl", false)) {
                this.fToolbar.add(this.fCbxSimulationSpeed);
            }
        }
        return this.fToolbar;
    }

    public SimulationManager getSimulationManager() {
        return this.fSimulationManager;
    }

    public Object getSelectedStepUnit() {
        return this.fCbXStepUnit.getSelectedItem();
    }

    public void setLabels() {
        this.fCycleField.setToolTipText(Language.getString("simulationControl.stepSimulation.cyles.tooltip", "Number of cycles for stepping"));
        this.fTimeField.setToolTipText(Language.getString("simulationControl.stepSimulation.duration.tooltip", "Length of time for stepping"));
        this.fCbXStepUnit.setToolTipText(Language.getString("simulationControl.stepSimulation.unit.tooltip", "Unit for stepping"));
        this.fCbxSimulationSpeed.setToolTipText(Language.getString("simulationControl.simulationSpeed.tooltip", "Simulation speed for time functions"));
        this.fNetButton.setToolTipText(Language.getString("button.net", "Net off"));
    }

    private void initComponents() {
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>();
        defaultComboBoxModel.addElement(new Cycles());
        defaultComboBoxModel.addElement(new Seconds());
        defaultComboBoxModel.addElement(new Minutes());
        defaultComboBoxModel.addElement(new Hours());
        this.fCbXStepUnit = new JComboBox(defaultComboBoxModel);
        this.fCbXStepUnit.setRenderer(new TimeUnitListCellRenderer(true));
        this.fCycleField = new IncrementableIntegerJTextField();
        this.fCycleField.setMin(1);
        this.fCycleField.setMax(1000);
        this.fCycleField.setColumns(5);
        this.fCycleField.setError(this.fCycleField.createDefaultError());
        this.fCycleField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!SimulationControl.this.fCycleField.checkValue(true)) {
                    if (SimulationControl.this.fCycleField.getValue() > SimulationControl.this.fCycleField.getMax()) {
                        SimulationControl.this.fCycleField.setValue(SimulationControl.this.fCycleField.getMax());
                    } else {
                        SimulationControl.this.fCycleField.setValue(SimulationControl.this.fCycleField.getMin());
                    }
                    SimulationControl.this.fCycleField.requestFocus();
                }
            }
        });
        MaskFormatter maskFormatter = null;
        try {
            maskFormatter = new MaskFormatter("##:## ");
            maskFormatter.setPlaceholderCharacter('0');
            this.fTimeField = new JFormattedTextField(maskFormatter);
            this.fTimeField.setColumns(5);
            this.fTimeField.setHorizontalAlignment(4);
            this.fTimeField.setValue("01:00 ");
        }
        catch (ParseException e) {
            // empty catch block
        }
        DefaultComboBoxModel<Double> comboBoxModel = new DefaultComboBoxModel<Double>(new Double[]{new Double(0.01), new Double(0.1), new Double(0.25), new Double(0.5), new Double(1.0), new Double(2.0), new Double(4.0), new Double(10.0), new Double(100.0), new Double(1000.0)});
        this.fCbxSimulationSpeed = new JComboBox<Double>(comboBoxModel);
        this.fCbxSimulationSpeed.setEditable(true);
        this.fCbxSimulationSpeed.setEditor(new PercentComboBoxEditor());
        this.fCbxSimulationSpeed.setRenderer(new PercentComboBoxRenderer());
        this.fLblTime = new TimeLabel();
        this.fLblTime.setFont(this.fLblTime.getFont().deriveFont(1));
        this.fToolbar = this.createToolBar();
    }

    public JFormattedTextField getTimeField() {
        return this.fTimeField;
    }

    public IncrementableIntegerJTextField getCycleField() {
        if (this.fCycleField != null && this.fCycleField.getValue() < 1) {
            this.fCycleField.setValue(1);
        }
        return this.fCycleField;
    }

    private void registerListeners() {
        this.fNetButton.addMouseListener(new NetButtonHandler());
        this.fCbXStepUnit.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SimulationControl.this.fStepAmountContainer.removeAll();
                if (e.getItem() instanceof Cycles) {
                    SimulationControl.this.fStepAmountContainer.add(SimulationControl.this.fCycleField);
                } else {
                    SimulationControl.this.fStepAmountContainer.add(SimulationControl.this.fTimeField);
                }
                SimulationControl.this.fStepAmountContainer.revalidate();
                SimulationControl.this.fStepAmountContainer.repaint();
            }
        });
        this.fCbxSimulationSpeed.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                double timeFactor = (Double)e.getItem();
                if (timeFactor != SimulationControl.this.getInterpreter().getTimeFactor()) {
                    SimulationControl.this.getInterpreter().setTimeFactor(timeFactor);
                }
            }
        });
        this.fLblTime.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    LogoToggleAction clockAction;
                    clockAction.setSelected(!(clockAction = (LogoToggleAction)SimulationControl.this.getActionFactory().getAction("DE.siemens.ad.pdraw.simulation.SetSimulationClockAction")).isSelected());
                    SimulationControl.this.getActionManager().invokeAction(clockAction);
                }
            }
        });
    }

    private void loadFieldContents() {
        Double timeFactor = new Double(this.getInterpreter().getTimeFactor());
        this.fCbxSimulationSpeed.setSelectedItem(timeFactor);
    }

    public OfflineInterpreter getInterpreter() {
        return (OfflineInterpreter)this.fSimulationManager.getInterpreter();
    }

    public void setStepProgressContent(String str) {
        this.fStepProgress.setText(str);
        this.fStepProgress.invalidate();
        this.fStepProgress.repaint();
    }

    protected class InterpreterStateChangedHandler
    implements StateMachine.StateChangedListener {
        protected InterpreterStateChangedHandler() {
        }

        public void finalStateReached(StateMachine stateMachine, StateMachine.State finalState) {
            SimulationControl.this.fSimulationManager.setVisualisationEnabled(false);
        }

        public void stateChanged(StateMachine stateMachine, StateMachine.State newState) {
            boolean steppingActive;
            this.enableDisableVisualisation(stateMachine, newState);
            ActionFactory actionFactory = SimulationControl.this.getActionFactory();
            boolean resumeActive = newState instanceof OfflineInterpreter.Suspended;
            if (resumeActive) {
                actionFactory.getAction("DE.siemens.ad.pdraw.simulation.SuspendResumeAction").putValue("SmallIcon", Global.getIcon("Resume.gif"));
            }
            boolean bl = steppingActive = newState instanceof OfflineInterpreter.TimerStepping || newState instanceof OfflineInterpreter.CycleStepping;
            if (steppingActive) {
                actionFactory.getAction("DE.siemens.ad.pdraw.simulation.StepSimulationAction").putValue("SmallIcon", Global.getIcon("RotatingStep.gif"));
            } else {
                actionFactory.getAction("DE.siemens.ad.pdraw.simulation.StepSimulationAction").putValue("SmallIcon", Global.getIcon("Step.gif"));
            }
            boolean suspendActive = newState instanceof OfflineInterpreter.Running || newState instanceof OfflineInterpreter.TimerStepping || newState instanceof OfflineInterpreter.CycleStepping;
            actionFactory.getAction("DE.siemens.ad.pdraw.simulation.SuspendResumeAction").setActivated(suspendActive || resumeActive);
            if (suspendActive) {
                actionFactory.getAction("DE.siemens.ad.pdraw.simulation.SuspendResumeAction").putValue("SmallIcon", Global.getIcon("Suspend.gif"));
            }
            boolean oneStepActive = newState instanceof OfflineInterpreter.Suspended || newState instanceof OfflineInterpreter.Stopped;
            actionFactory.getAction("DE.siemens.ad.pdraw.simulation.StepSimulationAction").setActivated(oneStepActive || newState instanceof OfflineInterpreter.CycleStepping || newState instanceof OfflineInterpreter.TimerStepping);
            SimulationControl.this.fCycleField.setEnabled(oneStepActive);
            SimulationControl.this.fTimeField.setEnabled(oneStepActive);
            SimulationControl.this.fCbXStepUnit.setEnabled(oneStepActive);
            boolean startSimulationActive = newState instanceof OfflineInterpreter.Stopped;
            actionFactory.getAction("DE.siemens.ad.pdraw.simulation.StartSimulationAction").setActivated(startSimulationActive);
            boolean stopSimulationActive = !(newState instanceof OfflineInterpreter.Stopped);
            actionFactory.getAction("DE.siemens.ad.pdraw.simulation.StopSimulationAction").setActivated(stopSimulationActive);
        }

        public void enableDisableVisualisation(StateMachine stateMachine, StateMachine.State newState) {
            boolean needsOutputReset;
            boolean needsVisualisation;
            boolean bl = needsVisualisation = newState != stateMachine.getState(OfflineInterpreter.Stopped.class) && newState != stateMachine.getState(OfflineInterpreter.Terminated.class) && newState != stateMachine.getState(OfflineInterpreter.TimerSteppingNetOff.class) && newState != stateMachine.getState(OfflineInterpreter.CycleSteppingNetOff.class) && newState != stateMachine.getState(OfflineInterpreter.SuspendedNetOff.class) && newState != stateMachine.getState(OfflineInterpreter.RunningNetOff.class);
            if (needsVisualisation != SimulationControl.this.fSimulationManager.isVisualisationEnabled()) {
                SimulationControl.this.fSimulationManager.setVisualisationEnabled(needsVisualisation);
                SimulationControl.this.fSimulationManager.initOutputs();
            }
            boolean bl2 = needsOutputReset = newState == stateMachine.getState(OfflineInterpreter.Stopped.class) || newState == stateMachine.getState(OfflineInterpreter.RunningNetOff.class) || newState == stateMachine.getState(OfflineInterpreter.SuspendedNetOff.class) || newState == stateMachine.getState(OfflineInterpreter.CycleSteppingNetOff.class) || newState == stateMachine.getState(OfflineInterpreter.TimerSteppingNetOff.class);
            if (needsOutputReset) {
                SimulationControl.this.fSimulationManager.resetOutputs();
            }
        }
    }

    protected class InterpreterHandler
    implements InterpreterListener {
        protected InterpreterHandler() {
        }

        public void interpreterCycleFinished(boolean somethingChanged) {
            String stepProgressText = "";
            StateMachine.State interpreterState = SimulationControl.this.getInterpreter().getStateMachine().getCurrentState();
            if (interpreterState instanceof OfflineInterpreter.CycleStepping) {
                stepProgressText = String.valueOf(SimulationControl.this.getInterpreter().getCyclesToRun() - 1);
            } else if (interpreterState instanceof OfflineInterpreter.TimerStepping) {
                stepProgressText = SimulationControl.this.getInterpreter().getStepTimer().getRemainingTime().getTimeAsString();
            }
            SimulationControl.this.setStepProgressContent(stepProgressText);
        }
    }

    public static class Cycles {
        public String toString() {
            return Language.getString("dialog.timeParameter.cycles", "Cycles");
        }
    }

    public static class PercentComboBoxRenderer
    extends DefaultListCellRenderer {
        private NumberFormat fPercentFormat = NumberFormat.getPercentInstance(Language.getLocale());

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setHorizontalTextPosition(4);
            this.setLayout(new FlowLayout(4));
            if (value instanceof Double) {
                this.setText(this.fPercentFormat.format(value));
            }
            return this;
        }
    }

    public static class PercentComboBoxEditor
    extends BasicComboBoxEditor {
        public PercentComboBoxEditor() {
            NumberFormatter numberFormatter = new NumberFormatter(NumberFormat.getPercentInstance(Language.getLocale()));
            numberFormatter.setMinimum(new Double(0.01));
            numberFormatter.setMaximum(new Double(1000.0));
            this.editor = new JFormattedTextField(numberFormatter);
            this.editor.setColumns(5);
            this.editor.setBorder(null);
            this.editor.setHorizontalAlignment(4);
        }

        public void setItem(Object anObject) {
            ((JFormattedTextField)this.editor).setValue(anObject);
        }

        public Object getItem() {
            Object item = ((JFormattedTextField)this.editor).getValue();
            return item;
        }
    }

    protected class TimeLabel
    extends JLabel {
        private long fTime;
        private DateFormat fTooltipDateTimeFormat = DateFormat.getDateTimeInstance(1, 1, Language.getLocale());
        private DateFormat fTextTimeFormat = DateFormat.getTimeInstance(2, Language.getLocale());

        public TimeLabel() {
            this.setTime(0L);
        }

        public long getTime() {
            return this.fTime;
        }

        public void setTime(long time) {
            this.fTime = time;
            Date newDate = new Date(time);
            this.setText(this.fTextTimeFormat.format(newDate));
            this.setToolTipText(this.fTooltipDateTimeFormat.format(newDate));
        }
    }

    protected class NetButtonHandler
    extends MouseAdapter {
        protected NetButtonHandler() {
        }

        public void mousePressed(MouseEvent e) {
            SimulationControl.this.getInterpreter().getStateMachine().addInput("netOff");
        }

        public void mouseReleased(MouseEvent e) {
            SimulationControl.this.getInterpreter().getStateMachine().addInput("netOn");
            super.mouseReleased(e);
        }
    }
}

